program DyrektywyKompilatora;

uses
  RTTI, System.SysUtils, TypInfo;

type
  {$M-}
  {$RTTI EXPLICIT METHODS([vcPublic]) PROPERTIES([vcPublic]) FIELDS([vcPublic])}
  TTylkoPubliczneElementy = class(TObject)
    private
      PolePrywatne: double;
      FPoleWłaściwościPublicznej: string;
      FPoleWłaściwościOpublikowanej: string;
      procedure MetodaPrywatna;
    protected
      PoleChronione: string;
      procedure MetodaChroniona;
    public
      PolePubliczne: integer;
      procedure MetodaPubliczna;
      property WłaściwośćPubliczna: string
        read FPoleWłaściwościPublicznej write FPoleWłaściwościPublicznej;
    published
    {$M-}
      PoleOpublikowane: TObject;
      function MetodaOpublikowana(aParam: string): integer;
      property WłaściwośćOpublikowana: string
        read FPoleWłaściwościOpublikowanej write FPoleWłaściwościOpublikowanej;
    {$M+}
  end;

procedure TTylkoPubliczneElementy.MetodaPrywatna;
begin
end;

procedure TTylkoPubliczneElementy.MetodaChroniona;
begin
end;

procedure TTylkoPubliczneElementy.MetodaPubliczna;
begin
end;

function TTylkoPubliczneElementy.MetodaOpublikowana(aParam: string): integer;
begin
end;

procedure OgraniczoneInformacjeRTTI;
var
  Kontekst: TRttiContext;
  TypTymcz: TRttiType;
  MetodaTymcz: TRttiMethod;
  WłaściwośćTymcz: TRttiProperty;
  PoleTymcz: TRttiField;
begin
  WriteLn('Poniżej powinny być wymienione tylko elementy publiczne klasy ', TTylkoPubliczneElementy.ClassName);
  TypTymcz := Kontekst.GetType(TTylkoPubliczneElementy);
  WriteLn('Pola:');
  for PoleTymcz in TypTymcz.GetDeclaredFields do
  begin
    WriteLn(' ', PoleTymcz.Name);
  end;

  WriteLn('Właściwości:');
  for WłaściwośćTymcz in TypTymcz.GetDeclaredProperties do
  begin
    WriteLn(' ', WłaściwośćTymcz.Name);
  end;

  WriteLn('Metody:');
  for MetodaTymcz in TypTymcz.GetDeclaredMethods do
  begin
    WriteLn(' ', MetodaTymcz.Name);
  end;
end;

begin
  OgraniczoneInformacjeRTTI;
  ReadLn;
end.
